package org.msh.tb.bd.dashboard.query;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;

import java.util.List;

/**
 * Created by Mauricio on 23/05/2017.
 */
public class Indicator10Query extends IndicatorQuery {

    @Override
    public Float calculateRate(Object[] o) {
        Long num1 = (Long) o[1];
        Long num2 = (Long) o[2];

        return DashboardIndicatorUtils.calcPercentage(num1, num2);
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select au.name.name1, " +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.patientType in (0, 48) and c.infectionSite = 0 and c.caseDefinition = 0 " +
                    "and c.state in (3, 7, 6) " +
                    "and p.workspace.id = :wsId)," +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.patientType in (0, 48) and c.infectionSite = 0 and c.caseDefinition = 0 " +
                    "and p.workspace.id = :wsId)" +
                "from AdministrativeUnit au " +
                "where au.workspace.id = :wsId " + adminUnitCondition +
                "order by au.name.name1")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }
}
